/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.system;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.pa.system.MOWrapper;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUIDFactory;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.xfw.pa.system.RemotePartitionSystem;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PASystem
implements Serializable,
Persistable,
XMLEncodeable,
MOWrapper {
    private static final String TRACE_MASKT = "XPAPSYST";
    private static final String TRACE_MASKF = "XPAPSYSF";
    private static final String TRACE_MASKD = "XPAPSYSD";
    public PASystemPersistentData psPD = null;

    public PASystem() {
        Trace.trace(TRACE_MASKD, "--> ctor");
        this.initPersistentData();
        this.psPD.uniqueKey = UUIDFactory.generate().toString();
        Trace.trace(TRACE_MASKD, "uniqueKey=" + this.psPD.uniqueKey);
        Trace.trace(TRACE_MASKD, "<-- ctor");
    }

    public PASystem(String machineType, String machineModel, String machineSerial) {
        this();
        this.setMachineType(machineType);
        this.setMachineModel(machineModel);
        this.setMachineSerial(machineSerial);
        this.setSystemName(this.getMTMS());
        Trace.trace(TRACE_MASKD, "toString=" + this);
    }

    public PASystem(PersistentData data) throws PersistenceException {
        this(((PASystemPersistentData)data).machineType, ((PASystemPersistentData)data).machineModel, ((PASystemPersistentData)data).machineSerial);
        Trace.trace(TRACE_MASKD, "<-> ctor: rebuilding " + this.getClass().getName() + " from PersistentData (sysName=" + this.getSystemName() + ")");
        this.psPD.uniqueKey = ((PASystemPersistentData)data).uniqueKey;
        this.setMOID(((PASystemPersistentData)data).moid);
        this.setDomainId(new DomainIdentifier(((PASystemPersistentData)data).domainId));
        this.psPD.ipAddrList = ((PASystemPersistentData)data).ipAddrList;
        Trace.trace(TRACE_MASKD, "Rebuilt PASystem [");
        Trace.trace(TRACE_MASKD, "uniqueKey=" + this.getUniqueKey());
        Trace.trace(TRACE_MASKD, "machineType=" + this.getMachineType());
        Trace.trace(TRACE_MASKD, "machineModel=" + this.getMachineModel());
        Trace.trace(TRACE_MASKD, "machineSerial=" + this.getMachineSerial());
        Trace.trace(TRACE_MASKD, "systemName=" + this.getSystemName());
        Trace.trace(TRACE_MASKD, "domainId=" + this.getDomainId().getDID());
        Trace.trace(TRACE_MASKD, "]");
    }

    private void initPersistentData() {
        this.psPD = new PASystemPersistentData();
    }

    public PersistentData getPersistentData() {
        return this.psPD;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public String getUniqueKey() {
        return this.psPD.uniqueKey;
    }

    public String getMachineType() {
        return this.psPD.machineType;
    }

    public void setMachineType(String machineType) {
        this.psPD.machineType = machineType;
    }

    public String getMachineModel() {
        return this.psPD.machineModel;
    }

    public void setMachineModel(String machineModel) {
        this.psPD.machineModel = machineModel;
    }

    public String getMachineSerial() {
        return this.psPD.machineSerial;
    }

    public void setMachineSerial(String machineSerial) {
        this.psPD.machineSerial = machineSerial;
    }

    public String getMTMS() {
        StringBuffer returnSB = new StringBuffer();
        if (this.getMachineType() != "") {
            returnSB.append(this.getMachineType() + "-");
        }
        if (this.getMachineModel() != "") {
            returnSB.append(this.getMachineModel() + "/");
        }
        returnSB.append(this.getMachineSerial());
        return returnSB.toString();
    }

    public static String extractMachineType(String mtms) {
        return mtms.substring(0, mtms.indexOf("-"));
    }

    public static String extractMachineModel(String mtms) {
        return mtms.substring(mtms.indexOf("-") + 1, mtms.indexOf("/"));
    }

    public static String extractMachineSerial(String mtms) {
        return mtms.substring(mtms.indexOf("/") + 1);
    }

    public String getSystemName() {
        return this.psPD.systemName;
    }

    public void setSystemName(String systemName) {
        this.psPD.systemName = systemName;
    }

    protected String getSystemTrace(String trace) {
        return "[" + this.getSystemName() + "] " + trace;
    }

    public void setMOID(ObjectId moid) {
        this.psPD.moid = moid;
    }

    public ManagedObject getMO() {
        if (this.psPD.moid == null) {
            return null;
        }
        ManagedObject mo = null;
        try {
            mo = (ManagedObject)ManagedObjectManager.getManagedObjectManager().get(this.psPD.moid);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "Unable to obtain ManagedObject [" + this.psPD.moid + "]");
            Trace.trace(TRACE_MASKD, e);
            return null;
        }
        return mo;
    }

    public String getMOSystemName() {
        ManagedObject mo = this.getMO();
        if (mo == null) {
            return null;
        }
        return mo.getUIInfo().getTitle();
    }

    public DomainIdentifier getDomainId() {
        return new DomainIdentifier(this.psPD.domainId);
    }

    public void setDomainId(DomainIdentifier id) {
        this.psPD.domainId = id.getDID();
    }

    public void addIPAddr(String ipAddr) {
        this.psPD.ipAddrList.add(ipAddr);
    }

    public XMLEncodeableArrayList getIPAddrList() {
        return this.psPD.ipAddrList;
    }

    public boolean equals(Object o) {
        if (this instanceof RemotePartitionSystem || o instanceof RemotePartitionSystem) {
            return this.getSystemName().equals(((PASystem)o).getSystemName()) && this.getClass().getName().equals(o.getClass().getName());
        }
        if (o instanceof PASystem) {
            return this.getSystemName().equals(((PASystem)o).getSystemName());
        }
        if (o instanceof ObjectId) {
            if (this.psPD.moid == null) {
                return false;
            }
            return this.psPD.moid.equals((ObjectId)o);
        }
        return false;
    }

    public int hashCode() {
        if (this.getSystemName() != null) {
            return this.getSystemName().hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.getSystemName();
    }

    public void toXML(StringBuffer sb) {
        StringBuffer probBuffer = new StringBuffer();
        XMLHelper.outToXML(this, probBuffer, this.getClass());
        sb.append(probBuffer.toString());
    }

    public void fromXML(Node node) {
        XMLHelper.rebuildObject(this, node);
    }

    public static void main(String[] args) {
        try {
            PASystem pas = new PASystem("ab", "cd", "1234");
            pas.addIPAddr("addr1");
            pas.addIPAddr("addr2");
            pas.addIPAddr("addr3");
            pas.addIPAddr("addr4");
            StringBuffer sb = new StringBuffer();
            XMLHelper.outToXML(pas, sb, pas.getClass());
            String pasXML = sb.toString();
            Trace.trace(TRACE_MASKD, "******\nout>>" + pasXML);
            Trace.trace(TRACE_MASKD, "<<out\n******");
            PASystem rbPas = (PASystem)XMLHelper.rebuildObject(pasXML, "*");
            sb = new StringBuffer();
            XMLHelper.outToXML(rbPas, sb, rbPas.getClass());
            String rbXML = sb.toString();
            Trace.trace(TRACE_MASKD, "******\nrebuilt>>" + rbXML);
            Trace.trace(TRACE_MASKD, "<<rebuilt\n******");
            Trace.trace(TRACE_MASKD, "pasXML=rbXML?" + pasXML.equals(rbXML));
            PASystem persPas = new PASystem(pas.getPersistentData());
            Trace.trace(TRACE_MASKD, "pas=rb?" + pas.equals(rbPas));
            Trace.trace(TRACE_MASKD, "pas=pers?" + pas.equals(persPas));
            Object pasCF = PersistenceManager.getPersistenceManager().objectToContainedForm(pas);
            PASystem persPas2 = (PASystem)PersistenceManager.getPersistenceManager().containedFormToObject(pasCF);
            Trace.trace(TRACE_MASKD, "pas=pers2?" + pas.equals(persPas2));
        }
        catch (Exception e) {}
    }

    public static class PASystemPersistentData
    implements PersistentData,
    XMLEncodeable {
        private static final long serialVersionUID = 2821825685557377724L;
        public String uniqueKey = "";
        public ObjectId moid = null;
        public String machineType = "";
        public String machineModel = "";
        public String machineSerial = "";
        public String systemName = "";
        public String domainId = "";
        public XMLEncodeableArrayList ipAddrList = new XMLEncodeableArrayList();

        public void toXML(StringBuffer sb) {
            sb.append("<PersistentData class=\"" + this.getClass().getName() + "\"");
            if (this.moid == null) {
                sb.append(" moid=\"null\"");
            } else {
                sb.append(" moid=\"" + XMLHelper.convertQuote(this.moid.toString()) + "\"");
            }
            sb.append(" machineType=\"" + XMLHelper.convertQuote(this.machineType) + "\"");
            sb.append(" machineModel=\"" + XMLHelper.convertQuote(this.machineModel) + "\"");
            sb.append(" machineSerial=\"" + XMLHelper.convertQuote(this.machineSerial) + "\"");
            sb.append(" systemName=\"" + XMLHelper.convertQuote(this.systemName) + "\"");
            sb.append(" domainId=\"" + XMLHelper.convertQuote(this.domainId) + "\"");
            sb.append("/>");
            this.ipAddrList.toXML(sb);
        }

        public void fromXML(Node node) {
            Trace.trace(PASystem.TRACE_MASKD, "--> PASystemPersistentData.fromXML");
            NodeList childNodes = node.getChildNodes();
            boolean foundPD = false;
            boolean foundIAL = false;
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeName().equals("PersistentData")) {
                    foundPD = true;
                    String moidString = XMLHelper.getAttributeValue(childNode, "moid");
                    if (moidString != null && !moidString.equals("null")) {
                        this.moid = new ObjectId(XMLHelper.unconvertQuote(moidString));
                    }
                    this.machineType = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(childNode, "machineType"));
                    this.machineModel = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(childNode, "machineModel"));
                    this.machineSerial = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(childNode, "machineSerial"));
                    this.systemName = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(childNode, "systemName"));
                    this.domainId = XMLHelper.unconvertQuote(XMLHelper.getAttributeValue(childNode, "domainId"));
                } else if (childNode.getNodeName().equals("list")) {
                    foundIAL = true;
                    this.ipAddrList.fromXML(childNode);
                } else {
                    Trace.trace(PASystem.TRACE_MASKT, "unknown node for PASystemPersistentData (" + childNode.getNodeName() + ").  Ignored");
                }
                ++i;
            }
            if (!foundPD) {
                Trace.trace(PASystem.TRACE_MASKT, "necessary 'PersistentData' node not found");
            }
            if (!foundIAL) {
                Trace.trace(PASystem.TRACE_MASKT, " necessary 'list' node not found");
            }
            Trace.trace(PASystem.TRACE_MASKD, "<-- PASystemPersistentData.fromXML");
        }
    }
}

